IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[CP_CD_Motivos_Habilitacion_Elegir]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [dbo].[CP_CD_Motivos_Habilitacion_Elegir] 
END
GO

CREATE PROCEDURE [dbo].[CP_CD_Motivos_Habilitacion_Elegir]
AS
/*Declaracion Variables Locales*/
DECLARE @Id_CD_Motivo			INT
DECLARE @Descripcion_Motivo		VARCHAR(5000)
DECLARE @Descripcion_Display	VARCHAR(32)
DECLARE @Descripcion_Pantalla	VARCHAR(100)
DECLARE @Mensaje				VARCHAR(5000)
/*Fin de Declaraciones Variables Locales */

PRINT 'Procedimiento: CP_CD_Motivos_Habilitacion_Elegir'
CREATE TABlE #CD_Motivos_Visibles (Id_CD_Motivo INT, Descripcion VARCHAR(5000))

BEGIN TRY
	BEGIN TRAN


		DECLARE curCDMot CURSOR FOR 
		SELECT
		CM.Id_CD_Motivo,
		ISNULL(CM.Descripcion, ''),
		ISNULL(CM.Descripcion_Display, ''),
		ISNULL(CM.Descripcion_Pantalla, '')
		FROM CD_Motivos CM
		WHERE
		ISNULL(CM.Activo, 0) = 1
		AND ISNULL(CM.Tipo, 'R') = 'H'
		AND ISNULL(CM.Flag_Sistema, 0) = 0

		OPEN curCDMot
		FETCH NEXT FROM curCDMot INTO @Id_CD_Motivo, @Descripcion_Motivo, @Descripcion_Display, @Descripcion_Pantalla
		WHILE @@FETCH_STATUS = 0
		BEGIN
			
			PRINT 'Id_CD_Motivo: ' + CONVERT(VARCHAR(10), @Id_CD_Motivo)

			IF(@Descripcion_Pantalla <> '')
			BEGIN
				SET @Mensaje = @Descripcion_Pantalla
			END
			ELSE
			BEGIN
				IF(@Descripcion_Display <> '')
				BEGIN
					SET @Mensaje = @Descripcion_Display
				END
				ELSE
				BEGIN
					SET @Mensaje = @Descripcion_Motivo
				END
			END

			INSERT INTO #CD_Motivos_Visibles
			(Id_CD_Motivo,	Descripcion)
			VALUES
			(@Id_CD_Motivo,	@Mensaje)

			FETCH NEXT FROM curCDMot INTO @Id_CD_Motivo, @Descripcion_Motivo, @Descripcion_Display, @Descripcion_Pantalla
		END 
		CLOSE curCDMot
		DEALLOCATE curCDMot

		SELECT Id_CD_Motivo, Descripcion FROM #CD_Motivos_Visibles ORDER BY Descripcion

		COMMIT
END TRY  


BEGIN CATCH  
    EXECUTE usp_GetErrorInfo;  
	ROLLBACK
END CATCH